/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netXTransport_Errors.h $:

  Description:
    netX Transport specific error code definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-10-10  Added int32_t cast for 64Bit systems
    2013-02-13  initial version

**************************************************************************************/

/****************************************************************************/
/*! \file netXTransport_Errors.h
    netX Transport specific error code definitions                          */
/****************************************************************************/

#ifndef __NETXTRANSPORT_ERRORS__H
#define __NETXTRANSPORT_ERRORS__H

#include <netXConnectorErrors.h>

#define NXT_NO_ERROR                          ((int32_t)0x00000000L)

/*******************************************************************************
* Generic Errors
*******************************************************************************/
#define NXT_INVALID_POINTER                   ((int32_t)0x80100001L)
#define NXT_INVALID_HANDLE                    ((int32_t)0x80100002L)
#define NXT_INVALID_PARAMETER                 ((int32_t)0x80100003L)
#define NXT_INVALID_COMMAND                   ((int32_t)0x80100004L)
#define NXT_INVALID_BUFFERSIZE                ((int32_t)0x80100005L)
#define NXT_INVALID_ACCESS_SIZE               ((int32_t)0x80100006L)
#define NXT_FUNCTION_FAILED                   ((int32_t)0x80100007L)
#define NXT_FILE_OPEN_FAILED                  ((int32_t)0x80100008L)
#define NXT_FILE_SIZE_ZERO                    ((int32_t)0x80100009L)
#define NXT_FILE_READ_ERROR                   ((int32_t)0x8010000AL)
#define NXT_FILE_WRITE_ERROR                  ((int32_t)0x8010000BL)
#define NXT_FUNCTION_NOT_AVAILABLE            ((int32_t)0x8010000CL)
#define NXT_BUFFER_TOO_SHORT                  ((int32_t)0x8010000DL)
#define NXT_RESOURCE_NOT_FOUND                ((int32_t)0x8010000EL)
#define NXT_NO_MEMORY                         ((int32_t)0x8010000FL)


/*******************************************************************************
* netXTransport API Errors
*******************************************************************************/
#define NXT_TOOLKIT_INIT_ERROR                ((int32_t)0x80200001L)
#define NXT_TL_INIT_ERROR                     ((int32_t)0x80200002L)
#define NXT_CONN_INIT_ERROR                   ((int32_t)0x80200003L)
#define NXT_HIL_INIT_ERROR                    ((int32_t)0x80200004L)
#define NXT_DUPLICATE_CONN_IDENTIFIER         ((int32_t)0x80200005L)
#define NXT_DUPLICATE_CONN_UUID               ((int32_t)0x80200006L)
#define NXT_DUPLICATE_TL_DATATYPE             ((int32_t)0x80200007L)
#define NXT_OUT_OF_MEMORY                     ((int32_t)0x80200008L)
#define NXT_SEND_TIMEOUT                      ((int32_t)0x80200009L)
#define NXT_RECV_TIMEOUT                      ((int32_t)0x8020000AL)
#define NXT_TRANSACTION_CANCELLED             ((int32_t)0x8020000BL)
#define NXT_UNSUPPORTED_DEVICE                ((int32_t)0x8020000CL)

#endif /* __NETXTRANSPORT_ERRORS__H */
